/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class FullResimage
extends JPanel
implements ActionListener,
MouseListener,
KeyListener {
    JFrame Frame = new JFrame(glb.software_name + " : Full Resolution Image");
    int Width = 500;
    int Height = 500;
    int img_scan;
    int img_pix;
    int cur_x = 250;
    int cur_y = 250;
    JButton close = new JButton("Close");
    JLabel scanpix = new JLabel();
    JComboBox size = new JComboBox();
    JComboBox zoom = new JComboBox();
    JLabel sizelabel = new JLabel("Window Size : ");
    JLabel zoomlabel = new JLabel("Zoom : ");
    BufferedImage image;

    protected void paintComponent(Graphics g) {
        g.clearRect(0, 0, this.Width, this.Height);
        g.drawImage(glb.adjustimage(this.image), 0, 0, this.Width, this.Height, this);
        g.setColor(Color.red);
        g.drawLine(this.cur_x - 5, this.cur_y, this.cur_x + 5, this.cur_y);
        g.drawLine(this.cur_x, this.cur_y - 5, this.cur_x, this.cur_y + 5);
    }

    void setFrame() {
        this.Frame.setResizable(false);
        this.Frame.add(this.scanpix);
        this.scanpix.setFont(new Font("Serif", 0, 12));
        this.scanpix.setText("<html><a color=\"blue\">Scan</a> : 0\t<a color=\"blue\">Pixel</a> : 0<br/><a color=\"red\">0</a> \t <a color=\"green\">0</a> \t <a color=\"blue\">0</a><br/><a color=\"black\"></html>");
        this.size.addItem("500");
        this.size.addItem("750");
        this.size.addItem("1000");
        this.size.setSelectedIndex(0);
        this.size.addActionListener(this);
        this.Frame.add(this.size);
        this.Frame.add(this.sizelabel);
        this.Frame.add(this);
        this.addMouseListener(this);
        this.Frame.add(this.close);
        this.close.addActionListener(this);
        this.zoom.addItem("50%");
        this.zoom.addItem("100%");
        this.zoom.addItem("200%");
        this.zoom.setSelectedItem("100%");
        this.zoom.addActionListener(this);
        this.Frame.add(this.zoom);
        this.Frame.add(this.zoomlabel);
        this.Frame.addKeyListener(this);
        this.zoom.setFocusable(false);
        this.size.setFocusable(false);
        this.setLayout();
    }

    void setLayout() {
        this.Frame.setSize(this.Width + 15, this.Height + 100);
        SpringLayout Layout = new SpringLayout();
        Layout.putConstraint("West", (Component)this.scanpix, 0, "West", (Component)this);
        Layout.putConstraint("North", (Component)this.scanpix, 6, "North", (Component)this.Frame);
        Layout.putConstraint("West", (Component)this.size, -70, "East", (Component)this);
        Layout.putConstraint("East", (Component)this.size, 0, "East", (Component)this);
        Layout.putConstraint("North", (Component)this.size, 5, "North", (Component)this.Frame);
        Layout.putConstraint("South", (Component)this.size, 0, "South", (Component)this.scanpix);
        Layout.putConstraint("West", (Component)this.sizelabel, -100, "West", (Component)this.size);
        Layout.putConstraint("East", (Component)this.sizelabel, -2, "West", (Component)this.size);
        Layout.putConstraint("North", (Component)this.sizelabel, 10, "North", (Component)this.Frame);
        Layout.putConstraint("West", (Component)this, 5, "West", (Component)this.Frame);
        Layout.putConstraint("East", (Component)this, this.Width, "West", (Component)this);
        Layout.putConstraint("North", (Component)this, 5, "South", (Component)this.scanpix);
        Layout.putConstraint("South", (Component)this, this.Height, "North", (Component)this);
        Layout.putConstraint("West", (Component)this.close, 0, "West", (Component)this);
        Layout.putConstraint("North", (Component)this.close, 5, "South", (Component)this);
        Layout.putConstraint("West", (Component)this.zoom, -70, "East", (Component)this);
        Layout.putConstraint("East", (Component)this.zoom, 0, "East", (Component)this);
        Layout.putConstraint("North", (Component)this.zoom, 5, "South", (Component)this);
        Layout.putConstraint("South", (Component)this.zoom, 0, "South", (Component)this.close);
        Layout.putConstraint("West", (Component)this.zoomlabel, -50, "West", (Component)this.zoom);
        Layout.putConstraint("East", (Component)this.zoomlabel, -2, "West", (Component)this.zoom);
        Layout.putConstraint("North", (Component)this.zoomlabel, 10, "South", (Component)this);
        this.Frame.setLayout(Layout);
    }

    void scanpix_setvalue() {
        this.img_pix = (int)((double)(Control.refimg.x * glb.Pix) * 1.0 / ((double)Control.refimg.Width * 1.0) - (double)this.Width * 1.0 / (2.0 * (double)glb.zlevel) + (double)this.cur_x * 1.0 / (double)glb.zlevel);
        this.img_scan = (int)((double)(Control.refimg.y * glb.Scan) * 1.0 / ((double)Control.refimg.Height * 1.0) - (double)this.Height * 1.0 / (2.0 * (double)glb.zlevel) + (double)this.cur_y * 1.0 / (double)glb.zlevel);
        String r = glb.pixelvalue(this.img_scan, this.img_pix, planeSelect.red);
        String g = glb.pixelvalue(this.img_scan, this.img_pix, planeSelect.green);
        String b = glb.pixelvalue(this.img_scan, this.img_pix, planeSelect.blue);
        this.scanpix.setText("<html><a color=\"blue\">Scan</a> : " + Integer.toString(this.img_scan + 1) + "\t<a color=\"blue\">Pixel</a> : " + Integer.toString(this.img_pix + 1) + "<br/><a color=\"red\">" + r + "</a> \t <a color=\"green\">" + g + "</a> \t <a color=\"blue\">" + b + "</a><br/><a color=\"black\"></html>");
        Control.ndump.setLayout();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.Frame.setVisible(false);
        } else if (e.getSource() == this.size) {
            if (this.size.getSelectedItem().toString().compareTo("500") == 0) {
                this.Width = 500;
                this.Height = 500;
            } else if (this.size.getSelectedItem().toString().compareTo("750") == 0) {
                this.Width = 750;
                this.Height = 750;
            } else if (this.size.getSelectedItem().toString().compareTo("1000") == 0) {
                this.Width = 1000;
                this.Height = 1000;
            }
            this.setLayout();
            glb.Cfrimage();
            Control.refimg.repaint();
        } else if (e.getSource() == this.zoom) {
            if (this.zoom.getSelectedItem().toString().compareTo("50%") == 0) {
                glb.zlevel = 0.5f;
            } else if (this.zoom.getSelectedItem().toString().compareTo("100%") == 0) {
                glb.zlevel = 1.0f;
            } else if (this.zoom.getSelectedItem().toString().compareTo("200%") == 0) {
                glb.zlevel = 2.0f;
            }
            this.setLayout();
            glb.Cfrimage();
            Control.refimg.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this) {
            this.cur_x = e.getX();
            this.cur_y = e.getY();
            this.scanpix_setvalue();
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37 && this.cur_x > 0) {
            --this.cur_x;
        } else if (e.getKeyCode() == 38 && this.cur_y > 0) {
            --this.cur_y;
        } else if (e.getKeyCode() == 39 && this.cur_x < this.Width - 1) {
            ++this.cur_x;
        } else if (e.getKeyCode() == 40 && this.cur_y < this.Height - 1) {
            ++this.cur_y;
        }
        if (e.getKeyCode() >= 37 && e.getKeyCode() <= 40) {
            this.scanpix_setvalue();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

