/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class Histogram
extends JPanel
implements ActionListener,
MouseListener {
    JFrame Frame = new JFrame();
    int Width = 285;
    int Height;
    JButton close = new JButton("Close");
    int[][] histcount = new int[10][256];
    int[] histmax = new int[10];
    int[][][] point = new int[10][2][4];
    int select = -1;

    protected void paintComponent(Graphics g) {
        int i;
        g.setFont(new Font("Serif", 0, 11));
        int rp = 0;
        int gp = 0;
        int bp = 0;
        if (planeSelect.mode == 1) {
            rp = 1;
            gp = 2;
            bp = 3;
        }
        g.clearRect(0, 0, this.Width, this.Height);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.Width, this.Height);
        g.setColor(Color.black);
        int w = 256;
        int h = 200;
        if (planeSelect.mode == 1) {
            g.setColor(Color.red);
        }
        g.drawRect(10, 10, w, h);
        if (planeSelect.red >= 0) {
            g.drawString(Integer.toString(glb.minmax[planeSelect.red][1]), w - 10, 33 + h);
            g.drawString(Integer.toString(glb.minmax[planeSelect.red][0]), 8, 33 + h);
            for (i = 1; i < 255; ++i) {
                g.drawLine(10 + i, 10 + h, 10 + i, 10 + h - this.histcount[planeSelect.red][i] * h / this.histmax[planeSelect.red]);
            }
            g.setColor(Color.black);
            g.fillRect(9 + this.point[planeSelect.red][0][rp], 10 + h, 3, 8);
            g.fillRect(9 + this.point[planeSelect.red][1][rp], 10 + h, 3, 8);
        }
        if (planeSelect.mode == 1) {
            g.setColor(Color.green);
            g.drawRect(10, h + 50, w, h);
            if (planeSelect.green >= 0) {
                g.drawString(Integer.toString(glb.minmax[planeSelect.green][1]), w - 10, 75 + 2 * h);
                g.drawString(Integer.toString(glb.minmax[planeSelect.green][0]), 8, 75 + 2 * h);
                for (i = 1; i < 255; ++i) {
                    g.drawLine(10 + i, 50 + h * 2, 10 + i, 50 + h * 2 - this.histcount[planeSelect.green][i] * h / this.histmax[planeSelect.green]);
                }
                g.setColor(Color.black);
                g.fillRect(9 + this.point[planeSelect.green][0][gp], 50 + 2 * h, 3, 8);
                g.fillRect(9 + this.point[planeSelect.green][1][gp], 50 + 2 * h, 3, 8);
            }
            g.setColor(Color.blue);
            g.drawRect(10, h * 2 + 90, w, h);
            if (planeSelect.blue >= 0) {
                g.drawString(Integer.toString(glb.minmax[planeSelect.blue][1]), w - 10, 115 + 3 * h);
                g.drawString(Integer.toString(glb.minmax[planeSelect.blue][0]), 8, 115 + 3 * h);
                for (i = 1; i < 255; ++i) {
                    g.drawLine(10 + i, h * 3 + 90, 10 + i, h * 3 + 90 - this.histcount[planeSelect.blue][i] * h / this.histmax[planeSelect.blue]);
                }
                g.setColor(Color.black);
                g.fillRect(9 + this.point[planeSelect.blue][0][bp], 90 + 3 * h, 3, 8);
                g.fillRect(9 + this.point[planeSelect.blue][1][bp], 90 + 3 * h, 3, 8);
            }
        }
    }

    void setFrame() {
        this.Frame.setTitle(glb.software_name + " :  Histogram");
        this.Frame.setResizable(false);
        this.Frame.getContentPane().setBackground(Color.white);
        this.Frame.add(this);
        this.Frame.add(this.close);
        this.close.addActionListener(this);
        this.addMouseListener(this);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.point[i][0][j] = 0;
                this.point[i][1][j] = 255;
            }
        }
        this.setLayout();
    }

    void setLayout() {
        if (planeSelect.mode == 0) {
            this.Height = 240;
        } else if (planeSelect.mode == 1) {
            this.Height = 720;
        }
        this.Frame.setSize(this.Width + 10, this.Height + 75);
        SpringLayout Layout = new SpringLayout();
        Layout.putConstraint("West", (Component)this, 5, "West", (Component)this.Frame);
        Layout.putConstraint("North", (Component)this, 5, "North", (Component)this.Frame);
        Layout.putConstraint("East", (Component)this, this.Width, "West", (Component)this.Frame);
        Layout.putConstraint("South", (Component)this, this.Height, "North", (Component)this.Frame);
        Layout.putConstraint("West", (Component)this.close, this.Width / 2 - 35, "West", (Component)this.Frame);
        Layout.putConstraint("North", (Component)this.close, 15, "South", (Component)this);
        this.Frame.setLayout(Layout);
        this.repaint();
        this.Frame.validate();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.Frame.setVisible(false);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            int h = 200;
            int rp = 0;
            int gp = 0;
            int bp = 0;
            int x = e.getX();
            int y = e.getY();
            if (planeSelect.mode == 1) {
                rp = 1;
                gp = 2;
                bp = 3;
            }
            if (y >= 10 + h && y <= 18 + h) {
                if (x >= 7 + this.point[planeSelect.red][0][rp] && x <= 14 + this.point[planeSelect.red][0][rp]) {
                    this.select = 0;
                } else if (x >= 7 + this.point[planeSelect.red][1][rp] && x <= 14 + this.point[planeSelect.red][1][rp]) {
                    this.select = 1;
                }
            } else if (y >= 50 + 2 * h && y <= 58 + 2 * h) {
                if (x >= 7 + this.point[planeSelect.green][0][gp] && x <= 14 + this.point[planeSelect.green][0][gp]) {
                    this.select = 2;
                } else if (x >= 7 + this.point[planeSelect.green][1][gp] && x <= 14 + this.point[planeSelect.green][1][gp]) {
                    this.select = 3;
                }
            } else if (y >= 90 + 3 * h && y <= 98 + 3 * h) {
                if (x >= 7 + this.point[planeSelect.blue][0][bp] && x <= 14 + this.point[planeSelect.blue][0][bp]) {
                    this.select = 4;
                } else if (x >= 7 + this.point[planeSelect.blue][1][bp] && x <= 14 + this.point[planeSelect.blue][1][bp]) {
                    this.select = 5;
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this && this.select >= 0) {
            int x = e.getX() - 9;
            int rp = 0;
            int gp = 0;
            int bp = 0;
            if (planeSelect.mode == 1) {
                rp = 1;
                gp = 2;
                bp = 3;
            }
            if (this.select == 0) {
                this.point[planeSelect.red][0][rp] = Math.max(0, Math.min(x, this.point[planeSelect.red][1][rp] - 10));
            } else if (this.select == 1) {
                this.point[planeSelect.red][1][rp] = Math.min(255, Math.max(x, this.point[planeSelect.red][0][rp] + 10));
            } else if (this.select == 2) {
                this.point[planeSelect.green][0][gp] = Math.max(0, Math.min(x, this.point[planeSelect.green][1][gp] - 10));
            } else if (this.select == 3) {
                this.point[planeSelect.green][1][gp] = Math.min(255, Math.max(x, this.point[planeSelect.green][0][gp] + 10));
            } else if (this.select == 4) {
                this.point[planeSelect.blue][0][bp] = Math.max(0, Math.min(x, this.point[planeSelect.blue][1][bp] - 10));
            } else if (this.select == 5) {
                this.point[planeSelect.blue][1][bp] = Math.min(255, Math.max(x, this.point[planeSelect.blue][0][bp] + 10));
            }
            this.repaint();
            Control.refimg.repaint();
            Control.frimage.repaint();
        }
        this.select = -1;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

