/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Input
extends JPanel
implements ActionListener,
Runnable {
    static JFrame Frame;
    JTextField[] BandMetaPath = new JTextField[10];
    JButton[] fileButton = new JButton[10];
    JComboBox Polarization = new JComboBox();
    ButtonGroup planegroup = new ButtonGroup();
    JRadioButton[] planeButton = new JRadioButton[10];
    JCheckBox[] prodchckbox = new JCheckBox[10];
    ButtonGroup prodgroup = new ButtonGroup();
    JRadioButton[] prodButton = new JRadioButton[2];
    JTextField outPath = new JTextField(17);
    JButton outButton = new JButton("...");
    JProgressBar wait = new JProgressBar();
    JButton loadButton = new JButton("Load");
    JButton closeButton = new JButton("Close");
    Thread regthread;
    static String jarpath;
    String pol = "";
    String outdir = "";
    String prodIndex = "";
    String refbandmeta = "";
    int product = 0;
    int refplane = 0;
    int[] filefound = new int[10];
    String ceosextractexe = "";
    String geotiffextractexe = "";
    String registrationexe = "";
    String modifybandmetaexe = "";
    String modifyxmlexe = "";
    String geotiffpackexe = "";
    String ceospackexe = "";
    String[] proddir = new String[10];
    String[] WOID = new String[10];
    String[] bandmeta = new String[10];
    String[] imgformat = new String[10];
    String[] imgscan = new String[10];
    String[] imgpix = new String[10];

    public static void main(String[] args) {
        float ver = Float.parseFloat(System.getProperty("java.specification.version"));
        if (ver < 1.6f) {
            JOptionPane.showMessageDialog(null, "Application requires Java Runtime Environment v1.6 or higher.");
            System.exit(0);
        }
        if (System.getProperty("os.name").contains("Linux")) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(System.getProperty("user.home") + "/.risat1mdrpath"));
                try {
                    jarpath = br.readLine();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Installation file is corrupted. Please reinstall.");
                    System.exit(0);
                }
                if (jarpath == null || !jarpath.endsWith("/")) {
                    JOptionPane.showMessageDialog(null, "Installation file corrupted. Please reinstall.");
                    System.exit(0);
                }
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "Installation not complete.");
                System.exit(0);
            }
        }
        InputMap im = (InputMap)UIManager.get("Button.focusInputMap");
        im.clear();
        ToolTipManager.sharedInstance().setInitialDelay(0);
        UIManager.getLookAndFeelDefaults().put("Label.font", new Font("Serif", 0, 12));
        UIManager.getLookAndFeelDefaults().put("RadioButton.font", new Font("Serif", 0, 13));
        UIManager.getLookAndFeelDefaults().put("ComboBox.font", new Font("Serif", 0, 12));
        UIManager.getLookAndFeelDefaults().put("Menu.font", new Font("Serif", 0, 13));
        UIManager.getLookAndFeelDefaults().put("MenuItem.font", new Font("Serif", 0, 13));
        UIManager.put("ProgressBar.selectionForeground", Color.red);
        UIManager.put("ProgressBar.selectionBackground", Color.red);
        Input obj = new Input();
        Control refimg_win = new Control();
        Input.initialize_data();
        refimg_win.setFrame();
        obj.setFrame();
    }

    private static void initialize_data() {
        for (int i = 0; i < 10; ++i) {
            glb.status[i] = 0;
        }
    }

    private void setFrame() {
        Frame = new JFrame();
        Frame.setTitle(glb.software_name);
        Frame.setSize(350, 688);
        Frame.setResizable(false);
        JPanel inputPanel = new JPanel();
        inputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), "Input", 0, 0, new Font("0", 0, 12), Color.blue));
        Frame.add(inputPanel);
        SpringLayout Layout = new SpringLayout();
        JLabel metalbl = new JLabel("Select Product BAND_META.txt");
        inputPanel.add(metalbl);
        Layout.putConstraint("North", (Component)metalbl, 10, "North", (Component)inputPanel);
        Layout.putConstraint("West", (Component)metalbl, 10, "West", (Component)inputPanel);
        JLabel[] file = new JLabel[10];
        for (int i = 0; i < 10; ++i) {
            file[i] = new JLabel("Product " + Integer.toString(i + 1) + " : ");
            inputPanel.add(file[i]);
            this.BandMetaPath[i] = new JTextField(17);
            this.fileButton[i] = new JButton("...");
            this.prodchckbox[i] = new JCheckBox();
            inputPanel.add(this.prodchckbox[i]);
            inputPanel.add(this.BandMetaPath[i]);
            inputPanel.add(this.fileButton[i]);
            this.fileButton[i].addActionListener(this);
            Layout.putConstraint("North", (Component)file[i], 30 + i * 25, "North", (Component)metalbl);
            Layout.putConstraint("West", (Component)file[i], 10, "West", (Component)metalbl);
            Layout.putConstraint("North", (Component)this.BandMetaPath[i], 0, "North", (Component)file[i]);
            Layout.putConstraint("West", (Component)this.BandMetaPath[i], 100, "West", (Component)inputPanel);
            Layout.putConstraint("North", (Component)this.prodchckbox[i], -4, "North", (Component)this.BandMetaPath[i]);
            Layout.putConstraint("West", (Component)this.prodchckbox[i], 0, "West", (Component)inputPanel);
            Layout.putConstraint("North", (Component)this.fileButton[i], 0, "North", (Component)this.BandMetaPath[i]);
            Layout.putConstraint("South", (Component)this.fileButton[i], 0, "South", (Component)this.BandMetaPath[i]);
            Layout.putConstraint("West", (Component)this.fileButton[i], 7, "East", (Component)this.BandMetaPath[i]);
            Layout.putConstraint("East", (Component)this.fileButton[i], 20, "West", (Component)this.fileButton[i]);
        }
        JLabel poltype = new JLabel("Polarization : ");
        inputPanel.add(poltype);
        this.Polarization.addItem("RH");
        this.Polarization.addItem("RV");
        this.Polarization.addItem("VH");
        this.Polarization.addItem("VV");
        this.Polarization.addItem("HH");
        this.Polarization.addItem("HV");
        this.Polarization.addItem("LH");
        this.Polarization.addItem("LV");
        inputPanel.add(this.Polarization);
        Layout.putConstraint("North", (Component)poltype, 25, "South", (Component)file[9]);
        Layout.putConstraint("West", (Component)poltype, 0, "West", (Component)metalbl);
        Layout.putConstraint("North", (Component)this.Polarization, 0, "North", (Component)poltype);
        Layout.putConstraint("West", (Component)this.Polarization, 20, "East", (Component)poltype);
        JLabel outlbl = new JLabel("Output Path : ");
        inputPanel.add(outlbl);
        inputPanel.add(this.outPath);
        inputPanel.add(this.outButton);
        this.outButton.addActionListener(this);
        Layout.putConstraint("North", (Component)outlbl, 25, "South", (Component)poltype);
        Layout.putConstraint("West", (Component)outlbl, 0, "West", (Component)metalbl);
        Layout.putConstraint("North", (Component)this.outPath, 0, "North", (Component)outlbl);
        Layout.putConstraint("West", (Component)this.outPath, 100, "West", (Component)inputPanel);
        Layout.putConstraint("North", (Component)this.outButton, 0, "North", (Component)outlbl);
        Layout.putConstraint("South", (Component)this.outButton, 0, "South", (Component)this.outPath);
        Layout.putConstraint("West", (Component)this.outButton, 0, "West", (Component)this.fileButton[0]);
        Layout.putConstraint("East", (Component)this.outButton, 0, "East", (Component)this.fileButton[0]);
        JLabel plane = new JLabel("Select Reference Product : ");
        inputPanel.add(plane);
        Layout.putConstraint("North", (Component)plane, 25, "South", (Component)outlbl);
        Layout.putConstraint("West", (Component)plane, 0, "West", (Component)metalbl);
        JLabel[] planeButtonlabel = new JLabel[10];
        for (int i = 0; i < 10; ++i) {
            this.planeButton[i] = new JRadioButton();
            planeButtonlabel[i] = new JLabel(Integer.toString(i + 1));
            this.planegroup.add(this.planeButton[i]);
            inputPanel.add(this.planeButton[i]);
            inputPanel.add(planeButtonlabel[i]);
            Layout.putConstraint("North", (Component)planeButtonlabel[i], 15, "South", (Component)plane);
            Layout.putConstraint("West", (Component)planeButtonlabel[i], 10 + i * 30, "West", (Component)plane);
            Layout.putConstraint("North", (Component)this.planeButton[i], 10, "South", (Component)planeButtonlabel[i]);
            Layout.putConstraint("West", (Component)this.planeButton[i], 5 + i * 30, "West", (Component)plane);
        }
        this.planeButton[0].setSelected(true);
        JLabel prod = new JLabel("Product type : ");
        inputPanel.add(prod);
        Layout.putConstraint("North", (Component)prod, 15, "South", (Component)this.planeButton[9]);
        Layout.putConstraint("West", (Component)prod, 0, "West", (Component)metalbl);
        this.prodButton[0] = new JRadioButton("Unregistred product");
        this.prodButton[1] = new JRadioButton("Registered product");
        for (int i = 0; i < 2; ++i) {
            this.prodgroup.add(this.prodButton[i]);
            inputPanel.add(this.prodButton[i]);
            Layout.putConstraint("North", (Component)this.prodButton[i], 10 + i * 30, "South", (Component)prod);
            Layout.putConstraint("West", (Component)this.prodButton[i], 10, "West", (Component)prod);
        }
        this.prodButton[1].setSelected(true);
        this.wait.setFont(new Font("Serif", 0, 12));
        inputPanel.add(this.wait);
        this.wait.setStringPainted(true);
        Layout.putConstraint("North", (Component)this.wait, -12, "South", (Component)inputPanel);
        Layout.putConstraint("South", (Component)this.wait, 2, "South", (Component)inputPanel);
        Layout.putConstraint("West", (Component)this.wait, -2, "West", (Component)inputPanel);
        Layout.putConstraint("East", (Component)this.wait, 2, "East", (Component)inputPanel);
        SpringLayout InputLayout = new SpringLayout();
        Frame.add(this.loadButton);
        Frame.add(this.closeButton);
        InputLayout.putConstraint("North", (Component)inputPanel, 10, "North", (Component)Frame);
        InputLayout.putConstraint("South", (Component)inputPanel, 618, "North", (Component)Frame);
        InputLayout.putConstraint("West", (Component)inputPanel, 5, "West", (Component)Frame);
        InputLayout.putConstraint("East", (Component)inputPanel, 340, "West", (Component)Frame);
        InputLayout.putConstraint("North", (Component)this.loadButton, 10, "South", (Component)inputPanel);
        InputLayout.putConstraint("West", (Component)this.loadButton, 95, "West", (Component)Frame);
        InputLayout.putConstraint("North", (Component)this.closeButton, 0, "North", (Component)this.loadButton);
        InputLayout.putConstraint("West", (Component)this.closeButton, 20, "East", (Component)this.loadButton);
        inputPanel.setLayout(Layout);
        Frame.setLayout(InputLayout);
        Frame.validate();
        this.loadButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.wait.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.closeButton) {
            Frame.setVisible(false);
        }
        for (i = 0; i < 10; ++i) {
            if (e.getSource() != this.fileButton[i]) continue;
            JFileChooser inputDir = new JFileChooser();
            inputDir.setDialogTitle("Select Product");
            inputDir.setCurrentDirectory(new File(this.BandMetaPath[i].getText()));
            inputDir.setFileFilter(new FileNameExtensionFilter("Text file", "txt"));
            if (inputDir.showOpenDialog(this) != 0) continue;
            String path = inputDir.getSelectedFile().toString();
            int loc = path.lastIndexOf("BAND_META.txt");
            if (!(loc != 0 && loc != -1 && loc != path.length() - 1 || path.endsWith("BAND_META.txt"))) {
                JOptionPane.showMessageDialog(null, "Invalid input file.\nPlease select a valid BAND_META file.");
                continue;
            }
            this.BandMetaPath[i].setText(path);
            this.prodchckbox[i].setSelected(true);
        }
        if (e.getSource() == this.outButton) {
            JFileChooser inputDir = new JFileChooser();
            inputDir.setDialogTitle("Output Directory");
            inputDir.setCurrentDirectory(new File(this.outPath.getText()));
            inputDir.setFileSelectionMode(1);
            if (inputDir.showOpenDialog(this) == 0) {
                String path = inputDir.getSelectedFile().toString();
                this.outPath.setText(path);
            }
        }
        if (e.getSource() == this.loadButton) {
            this.pol = this.Polarization.getSelectedItem().toString();
            this.outdir = this.outPath.getText();
            this.prodIndex = "";
            this.product = 0;
            this.refplane = 0;
            this.filefound = new int[10];
            for (i = 0; i < 10; ++i) {
                if (!this.planeButton[i].isSelected()) continue;
                this.refplane = i;
            }
            if (this.prodButton[1].isSelected()) {
                this.product = 1;
            }
            if (this.outdir.isEmpty() && this.product == 1) {
                JOptionPane.showMessageDialog(null, "Please select output directory to create registered products.");
            } else if (!this.BandMetaPath[this.refplane].getText().endsWith("BAND_META.txt")) {
                JOptionPane.showMessageDialog(null, "BAND_META not found for refrence product.");
            } else {
                String errorprodlist = " ";
                this.wait.setString("");
                this.wait.setVisible(true);
                this.setProgress(-1);
                this.loadButton.setEnabled(false);
                boolean polchck = true;
                boolean nodechck = true;
                boolean beamchck = true;
                boolean modechck = true;
                boolean prodchck = true;
                boolean imgformatchck = true;
                String Mode = "";
                String Node = "";
                String Prodtype = "";
                String Numbeam = "";
                String Beamstart = "";
                String Beamend = "";
                String Imgformat = "";
                this.outdir = this.outdir + "/";
                this.refbandmeta = this.BandMetaPath[this.refplane].getText();
                this.proddir = new String[10];
                this.WOID = new String[10];
                this.bandmeta = new String[10];
                this.imgformat = new String[10];
                this.imgscan = new String[10];
                this.imgpix = new String[10];
                try {
                    FileInputStream in = new FileInputStream(this.refbandmeta);
                    Properties prop = new Properties();
                    try {
                        if (this.refbandmeta.endsWith("BAND_META.txt")) {
                            prop.load(in);
                            Node = prop.getProperty("Node");
                            Prodtype = prop.getProperty("ProductType");
                            Mode = prop.getProperty("ImagingMode");
                            Imgformat = prop.getProperty("ImageFormat");
                            Numbeam = prop.getProperty("NumberOfBeams");
                            Beamstart = prop.getProperty("BeamNumber1");
                            Beamend = prop.getProperty("BeamNumber" + Numbeam);
                        } else {
                            JOptionPane.showMessageDialog(null, "Refrence BAND_META path is invalid.");
                        }
                        for (int plane = 0; plane < 10; ++plane) {
                            glb.status[plane] = 0;
                            int polcount = 0;
                            this.bandmeta[plane] = this.BandMetaPath[plane].getText();
                            if (this.bandmeta[plane].endsWith("BAND_META.txt") && (this.prodchckbox[plane].isSelected() || plane == this.refplane)) {
                                this.filefound[plane] = 1;
                                in = new FileInputStream(this.bandmeta[plane]);
                                prop.load(in);
                                this.WOID[plane] = prop.getProperty("ProductID");
                                this.proddir[plane] = this.bandmeta[plane].substring(0, this.bandmeta[plane].lastIndexOf("BAND_META.txt"));
                                this.imgformat[plane] = prop.getProperty("ImageFormat");
                                this.imgscan[plane] = prop.getProperty("NoScans");
                                this.imgpix[plane] = prop.getProperty("NoPixels");
                                if (prop.getProperty("Node").compareTo(Node) != 0) {
                                    nodechck = false;
                                }
                                if (prop.getProperty("ProductType").compareTo(Prodtype) != 0) {
                                    prodchck = false;
                                }
                                if (prop.getProperty("ImageFormat").compareTo(Imgformat) != 0) {
                                    imgformatchck = false;
                                }
                                if (prop.getProperty("ImagingMode").compareTo(Mode) != 0) {
                                    modechck = false;
                                }
                                if (prop.getProperty("NumberOfBeams").compareTo(Numbeam) != 0) {
                                    beamchck = false;
                                }
                                if (prop.getProperty("BeamNumber1").compareTo(Beamstart) != 0) {
                                    beamchck = false;
                                }
                                if (prop.getProperty("BeamNumber" + Numbeam).compareTo(Beamend) != 0) {
                                    beamchck = false;
                                }
                                for (int i2 = 1; i2 <= Integer.parseInt(prop.getProperty("NoOfPolarizations")); ++i2) {
                                    if (prop.getProperty("TxRxPol" + i2).compareTo(this.pol) != 0) continue;
                                    ++polcount;
                                }
                                if (polcount != 1) {
                                    polchck = false;
                                }
                                if (plane == this.refplane || polchck && nodechck && prodchck && modechck && beamchck && imgformatchck) continue;
                                errorprodlist = errorprodlist + Integer.toString(plane + 1) + ", ";
                                continue;
                            }
                            this.filefound[plane] = 0;
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Error reading BAND_META.");
                    }
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "BAND_META not found.");
                }
                if (Prodtype.equalsIgnoreCase("L0-RAW")) {
                    this.prodIndex = "0";
                } else if (Prodtype.equalsIgnoreCase("L1-SLANT-RANGE")) {
                    this.prodIndex = "1";
                } else if (Prodtype.equalsIgnoreCase("L1-GROUND-RANGE")) {
                    this.prodIndex = "2";
                } else if (Prodtype.equalsIgnoreCase("L2-GEOREF")) {
                    this.prodIndex = "3";
                }
                if (this.prodIndex.compareTo("3") == 0 && polchck && nodechck && prodchck && modechck && beamchck && imgformatchck) {
                    for (int plane = 0; plane < 10; ++plane) {
                        Control.splane.RplaneButton[plane].setEnabled(false);
                        Control.splane.GplaneButton[plane].setEnabled(false);
                        Control.splane.BplaneButton[plane].setEnabled(false);
                    }
                    this.ceosextractexe = "";
                    this.geotiffextractexe = "";
                    this.registrationexe = "";
                    this.modifybandmetaexe = "";
                    this.modifyxmlexe = "";
                    this.geotiffpackexe = "";
                    this.ceospackexe = "";
                    boolean exechck = false;
                    ProcessBuilder pb = null;
                    Process p = null;
                    int retcode = 0;
                    String[] cmd = new String[]{};
                    if (System.getProperty("os.name").contains("Linux")) {
                        this.ceosextractexe = jarpath + "exe/risat1_ceos_extract_linux.exe";
                        this.geotiffextractexe = jarpath + "exe/risat1_geotiff_extract_linux.exe";
                        this.registrationexe = jarpath + "exe/risat1_multiDateReg_linux.exe";
                        this.modifybandmetaexe = jarpath + "exe/risat1_modify_band_meta_linux.exe";
                        this.modifyxmlexe = jarpath + "exe/risat1_modify_xml_linux.exe";
                        this.geotiffpackexe = jarpath + "exe/risat1_geotiff_pack_linux.exe";
                        this.ceospackexe = jarpath + "exe/risat1_ceos_pack_linux.exe";
                        exechck = true;
                    } else if (System.getProperty("os.name").contains("Windows")) {
                        this.ceosextractexe = "exe/risat1_ceos_extract_windows.exe";
                        this.geotiffextractexe = "exe/risat1_geotiff_extract_windows.exe";
                        this.registrationexe = "exe/risat1_multiDateReg_windows.exe";
                        this.modifybandmetaexe = "exe/risat1_modify_band_meta_windows.exe";
                        this.modifyxmlexe = "exe/risat1_modify_xml_windows.exe";
                        this.geotiffpackexe = "exe/risat1_geotiff_pack_windows.exe";
                        this.ceospackexe = "exe/risat1_ceos_pack_windows.exe";
                        exechck = true;
                    } else {
                        JOptionPane.showMessageDialog(null, "Current OS [" + System.getProperty("os.name") + "] is not supported.");
                    }
                    if (exechck) {
                        int plane;
                        for (plane = 0; plane < 10; ++plane) {
                            this.wait.setString("Extracting Product " + (plane + 1));
                            this.setProgress(plane * 10);
                            if (this.filefound[plane] != 1) continue;
                            File dir = new File(this.proddir[plane] + "/" + this.WOID[plane] + "_scene_" + this.pol);
                            dir.mkdirs();
                            if (this.imgformat[plane].compareTo("GEOTIFF") == 0) {
                                cmd = new String[]{this.geotiffextractexe, this.proddir[plane], this.pol, this.imgscan[plane], this.imgpix[plane], dir.getPath()};
                            } else if (this.imgformat[plane].compareTo("CEOS") == 0) {
                                cmd = new String[]{this.ceosextractexe, this.prodIndex, this.proddir[plane] + "/scene_" + this.pol, this.proddir[plane], this.WOID[plane]};
                            }
                            boolean fileexistchck = false;
                            try {
                                RandomAccessFile img = new RandomAccessFile(dir.getPath() + "/DATA_FILE_PROCESSED.img", "r");
                                try {
                                    if (img.length() == (long)(Integer.parseInt(this.imgscan[plane]) * Integer.parseInt(this.imgpix[plane]) * 4)) {
                                        fileexistchck = true;
                                    }
                                }
                                catch (IOException ex) {
                                    fileexistchck = false;
                                }
                            }
                            catch (FileNotFoundException ex) {
                                fileexistchck = false;
                            }
                            if (fileexistchck) continue;
                            try {
                                pb = new ProcessBuilder(cmd);
                                p = pb.start();
                                try {
                                    retcode = p.waitFor();
                                    if (retcode == 0) continue;
                                    JOptionPane.showMessageDialog(null, "Error extracting data.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                }
                                catch (InterruptedException ex) {
                                    JOptionPane.showMessageDialog(null, "Error extracting data.\nProduct " + (plane + 1));
                                    retcode = -100;
                                }
                                continue;
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(null, "Data extractor initiation failed.");
                                retcode = -100;
                            }
                        }
                        if (retcode == 0) {
                            this.wait.setString("Analyzing Refrence Product");
                            this.setProgress(0);
                            planeSelect.red = this.refplane;
                            planeSelect.green = this.refplane;
                            planeSelect.blue = this.refplane;
                            Control.splane.RplaneButton[this.refplane].setSelected(true);
                            Control.splane.GplaneButton[this.refplane].setSelected(true);
                            Control.splane.BplaneButton[this.refplane].setSelected(true);
                            this.addimagefile(this.refplane, this.proddir[this.refplane] + "/" + this.WOID[this.refplane] + "_scene_" + this.pol + "/DATA_FILE_PROCESSED.img", Integer.parseInt(this.imgpix[this.refplane]), Integer.parseInt(this.imgscan[this.refplane]));
                            this.setProgress(10);
                        }
                        if (this.product == 0 && retcode == 0) {
                            for (plane = 0; plane < 10; ++plane) {
                                this.wait.setString("Analyzing Product " + (plane + 1));
                                this.setProgress(plane * 10);
                                if (this.filefound[plane] != 1 || plane == this.refplane) continue;
                                this.addimagefile(plane, this.proddir[plane] + "/" + this.WOID[plane] + "_scene_" + this.pol + "/DATA_FILE_PROCESSED.img", Integer.parseInt(this.imgpix[plane]), Integer.parseInt(this.imgscan[plane]));
                            }
                            this.resetFrame();
                        } else if (this.product == 1 && retcode == 0) {
                            this.regthread = new Thread((Runnable)this, "registration");
                            this.regthread.start();
                        } else {
                            this.resetFrame();
                        }
                    } else {
                        this.resetFrame();
                    }
                } else {
                    if (this.prodIndex.compareTo("3") != 0) {
                        JOptionPane.showMessageDialog(null, "Only Level-2 Geo-refrenced products registration is supported.\nPlease check the refrence product.");
                    } else if (!polchck) {
                        JOptionPane.showMessageDialog(null, "Selected polarization not found in Products : " + errorprodlist + "\nPlease correct or deselect the products.");
                    } else if (!nodechck) {
                        JOptionPane.showMessageDialog(null, "Products" + errorprodlist + "are not of same node[Ascending/Descending] as the refrence product.\nPlease correct or deselect the products.");
                    } else if (!modechck) {
                        JOptionPane.showMessageDialog(null, "Products" + errorprodlist + " are not of same mode as the refrence product.\nPlease correct or deselect the products.");
                    } else if (!imgformatchck) {
                        JOptionPane.showMessageDialog(null, "Products" + errorprodlist + "are not of same imaging format [CEOS/GEOTIFF] as the refrence product.\nPlease correct or deselect the products.");
                    } else if (!beamchck) {
                        JOptionPane.showMessageDialog(null, "Products" + errorprodlist + "are not imaged in same beams as the refrence product.\nPlease correct or deselect the products.");
                    } else if (!prodchck) {
                        JOptionPane.showMessageDialog(null, "Products" + errorprodlist + "are not of same product type as the refrence product.\nPlease correct or deselect the products.");
                    }
                    this.resetFrame();
                    Frame.setVisible(true);
                }
            }
        }
    }

    void addimagefile(int plane, String file, int pix, int scan) {
        try {
            RandomAccessFile img = new RandomAccessFile(file, "r");
            try {
                long len = img.length();
                img.seek(0L);
                img.read();
                img.seek(len - 1L);
                img.read();
                if (pix > 0 && scan > 0 && (long)(scan * pix * 4) == len) {
                    glb.datatype[plane] = 2;
                    glb.file[plane] = file;
                    glb.headerBytes[plane] = 0;
                    glb.minmax[plane][0] = 0;
                    glb.minmax[plane][1] = 65535;
                    glb.pix[plane] = pix;
                    glb.scan[plane] = scan;
                    glb.status[plane] = 1;
                    Control.splane.enableplane(plane, plane, plane);
                    for (int i = 0; i < 4; ++i) {
                        Control.histogram.point[plane][0][i] = 0;
                        Control.histogram.point[plane][1][i] = 255;
                    }
                    glb.setHistogram(plane);
                    if (plane == planeSelect.red || plane == planeSelect.green || plane == planeSelect.blue) {
                        glb.CRefimage();
                        glb.Cfrimage();
                        Control.histogram.setLayout();
                        Control.frimage.scanpix_setvalue();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Error populating data for image " + (plane + 1) + ".");
                }
                img.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading file : " + file);
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Image file : " + file + " not found.");
        }
    }

    void setProgress(int p) {
        if (p >= 0) {
            this.wait.setIndeterminate(false);
            this.wait.setValue(p);
        } else {
            this.wait.setIndeterminate(true);
        }
        this.wait.paintImmediately(0, 0, this.wait.getWidth(), this.wait.getHeight());
    }

    public void run() {
        File dir = new File(this.outdir);
        dir.mkdirs();
        String[] cmd = new String[]{};
        if (Thread.currentThread().getName().compareTo("registration") == 0) {
            for (int plane = 0; plane < 10; ++plane) {
                Process p;
                ProcessBuilder pb;
                boolean procchck = true;
                int retcode = 0;
                this.wait.setString("Registering Product " + (plane + 1));
                this.setProgress(plane * 10);
                if (this.filefound[plane] != 1 || plane == this.refplane) continue;
                dir = new File(this.outdir + this.WOID[plane] + "_Registered");
                dir.mkdirs();
                cmd = new String[]{this.registrationexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane], this.pol};
                try {
                    pb = new ProcessBuilder(cmd);
                    p = pb.start();
                    try {
                        retcode = p.waitFor();
                        if (retcode != 0) {
                            if (retcode == 45) {
                                JOptionPane.showMessageDialog(null, "Overlap region not found for Product " + (plane + 1) + ".\nProduct cannot be registered.");
                            } else {
                                JOptionPane.showMessageDialog(null, "Error in product registration.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                            }
                            procchck = false;
                        }
                    }
                    catch (InterruptedException ex) {
                        JOptionPane.showMessageDialog(null, "Error in product registration.\nProduct " + (plane + 1));
                        procchck = false;
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Registration initiation failed.");
                    procchck = false;
                }
                this.setProgress(this.wait.getValue() + 5);
                if (procchck) {
                    this.wait.setString("Repacking Registered Product " + (plane + 1));
                    cmd = new String[]{this.modifybandmetaexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane]};
                    try {
                        pb = new ProcessBuilder(cmd);
                        p = pb.start();
                        try {
                            retcode = p.waitFor();
                            if (retcode != 0) {
                                JOptionPane.showMessageDialog(null, "Error in BAND_META generation.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                procchck = false;
                            }
                        }
                        catch (InterruptedException ex) {
                            JOptionPane.showMessageDialog(null, "Error in BAND_META generation.\nProduct " + (plane + 1));
                            procchck = false;
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "BAND_META generation initiation failed.");
                        procchck = false;
                    }
                }
                this.setProgress(this.wait.getValue() + 1);
                if (this.imgformat[plane].compareTo("GEOTIFF") == 0) {
                    if (procchck) {
                        cmd = new String[]{this.geotiffpackexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane], this.pol};
                        try {
                            pb = new ProcessBuilder(cmd);
                            p = pb.start();
                            try {
                                retcode = p.waitFor();
                                if (retcode != 0) {
                                    JOptionPane.showMessageDialog(null, "Error in geotiff product generation.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                    procchck = false;
                                }
                            }
                            catch (InterruptedException ex) {
                                JOptionPane.showMessageDialog(null, "Error in geotiff product generation.\nProduct " + (plane + 1));
                                procchck = false;
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(null, "Geotiff product generation initiation failed.");
                            procchck = false;
                        }
                    }
                    if (procchck) {
                        if (System.getProperty("os.name").contains("Linux")) {
                            try {
                                String libpath = jarpath + "exe/";
                                BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("getconf LONG_BIT").getInputStream()));
                                String line = reader.readLine();
                                if (line.startsWith("32")) {
                                    libpath = jarpath + "exe/XML_PACK/32bit/";
                                    this.modifyxmlexe = jarpath + "exe/XML_PACK/32bit/risat1_modify_xml_linux.exe";
                                } else if (line.startsWith("64")) {
                                    libpath = jarpath + "exe/XML_PACK/64bit/";
                                    this.modifyxmlexe = jarpath + "exe/XML_PACK/64bit/risat1_modify_xml_linux.exe";
                                } else {
                                    libpath = jarpath + "exe/";
                                    this.modifyxmlexe = jarpath + "exe/risat1_modify_xml_linux.exe";
                                }
                                cmd = new String[]{this.modifyxmlexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane]};
                                pb = new ProcessBuilder(cmd);
                                pb.environment().put("LD_LIBRARY_PATH", libpath);
                                p = pb.start();
                                try {
                                    retcode = p.waitFor();
                                    if (retcode != 0) {
                                        JOptionPane.showMessageDialog(null, "Error in XML generation.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                        procchck = false;
                                    }
                                }
                                catch (InterruptedException ex) {
                                    JOptionPane.showMessageDialog(null, "Error in XML generation.\nProduct " + (plane + 1));
                                    procchck = false;
                                }
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(null, "XML generation initiation failed.\nPlease ensure you have gcc version higher than or equal to 4.1.2");
                                procchck = false;
                            }
                        } else if (System.getProperty("os.name").contains("Windows")) {
                            cmd = new String[]{this.modifyxmlexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane]};
                            try {
                                pb = new ProcessBuilder(cmd);
                                p = pb.start();
                                try {
                                    retcode = p.waitFor();
                                    if (retcode != 0) {
                                        JOptionPane.showMessageDialog(null, "Error in XML generation.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                        procchck = false;
                                    }
                                }
                                catch (InterruptedException ex) {
                                    JOptionPane.showMessageDialog(null, "Error in XML generation.\nProduct " + (plane + 1));
                                    procchck = false;
                                }
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(null, "XML generation initiation failed.");
                                procchck = false;
                            }
                        }
                    }
                } else if (this.imgformat[plane].compareTo("CEOS") == 0 && procchck) {
                    cmd = new String[]{this.ceospackexe, this.proddir[this.refplane], this.proddir[plane], this.outdir, this.WOID[this.refplane], this.WOID[plane], this.pol};
                    try {
                        pb = new ProcessBuilder(cmd);
                        p = pb.start();
                        try {
                            retcode = p.waitFor();
                            if (retcode != 0) {
                                JOptionPane.showMessageDialog(null, "Error in ceos product generation.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                procchck = false;
                            }
                        }
                        catch (InterruptedException ex) {
                            JOptionPane.showMessageDialog(null, "Error in ceos product generation.\nProduct " + (plane + 1));
                            procchck = false;
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "CEOS product generation initiation failed.");
                        procchck = false;
                    }
                }
                this.setProgress(this.wait.getValue() + 2);
                if (procchck) {
                    this.wait.setString("Extracting Registered Product " + (plane + 1));
                    dir = new File(this.outdir + this.WOID[plane] + "_Registered/" + this.WOID[plane] + "_Registered_scene_" + this.pol);
                    dir.mkdirs();
                    if (this.imgformat[plane].compareTo("GEOTIFF") == 0) {
                        cmd = new String[]{this.geotiffextractexe, this.outdir + this.WOID[plane] + "_Registered", this.pol, this.imgscan[this.refplane], this.imgpix[this.refplane], dir.getPath()};
                    } else if (this.imgformat[plane].compareTo("CEOS") == 0) {
                        cmd = new String[]{this.ceosextractexe, this.prodIndex, this.outdir + this.WOID[plane] + "_Registered/scene_" + this.pol, this.outdir + this.WOID[plane] + "_Registered", this.WOID[plane] + "_Registered"};
                    }
                    try {
                        pb = new ProcessBuilder(cmd);
                        p = pb.start();
                        try {
                            retcode = p.waitFor();
                            if (retcode != 0) {
                                JOptionPane.showMessageDialog(null, "Error extracting generated data.\nProduct " + (plane + 1) + "\nError Code : " + retcode);
                                procchck = false;
                            }
                        }
                        catch (InterruptedException ex) {
                            JOptionPane.showMessageDialog(null, "Error extracting generated data.\nProduct " + (plane + 1));
                            procchck = false;
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Data extractor initiation failed.");
                        procchck = false;
                    }
                }
                this.setProgress(this.wait.getValue() + 1);
                if (procchck) {
                    this.addimagefile(plane, this.outdir + this.WOID[plane] + "_Registered/" + this.WOID[plane] + "_Registered_scene_" + this.pol + "/DATA_FILE_PROCESSED.img", Integer.parseInt(this.imgpix[this.refplane]), Integer.parseInt(this.imgscan[this.refplane]));
                }
                this.setProgress(this.wait.getValue() + 1);
                File file = new File(this.outdir + this.WOID[plane] + "_Registered/image_" + this.pol + ".bin");
                file.delete();
            }
        }
        this.resetFrame();
        Thread.currentThread().interrupt();
    }

    void resetFrame() {
        this.loadButton.setEnabled(true);
        this.wait.setVisible(false);
        Frame.setVisible(false);
    }

    static {
        jarpath = "";
    }
}

