/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.JOptionPane;

public class glb {
    static String software_name = "MUDAT";
    static int[] status = new int[10];
    static String[] file = new String[10];
    static int[] scan = new int[10];
    static int[] pix = new int[10];
    static int[] headerBytes = new int[10];
    static int[][] minmax = new int[10][2];
    static int[] datatype = new int[10];
    static int Scan = 0;
    static int Pix = 0;
    static float zlevel = 1.0f;

    public static void CRefimage() {
        int r = planeSelect.red;
        int g = planeSelect.green;
        int b = planeSelect.blue;
        int rsize = 0;
        int gsize = 0;
        int bsize = 0;
        Scan = 0;
        Pix = 0;
        if (datatype[r] == 0 || datatype[r] == 1) {
            rsize = 1;
        } else if (datatype[r] == 2 || datatype[r] == 3) {
            rsize = 4;
        }
        if (datatype[g] == 0 || datatype[g] == 1) {
            gsize = 1;
        } else if (datatype[g] == 2 || datatype[g] == 3) {
            gsize = 4;
        }
        if (datatype[b] == 0 || datatype[b] == 1) {
            bsize = 1;
        } else if (datatype[b] == 2 || datatype[b] == 3) {
            bsize = 4;
        }
        Scan = Math.max(scan[r], Math.max(scan[g], scan[b]));
        Pix = Math.max(pix[r], Math.max(pix[g], pix[b]));
        Scan = Math.max(Scan, Pix);
        Pix = Math.max(Scan, Pix);
        float scan_inc = (float)Math.floor((double)Scan * 1.0 / (double)Control.refimg.Height);
        float pix_inc = (float)Math.floor((double)Pix * 1.0 / (double)Control.refimg.Width);
        try {
            RandomAccessFile rimg = new RandomAccessFile(file[r], "r");
            RandomAccessFile gimg = new RandomAccessFile(file[g], "r");
            RandomAccessFile bimg = new RandomAccessFile(file[b], "r");
            FileChannel rimgc = rimg.getChannel();
            FileChannel gimgc = gimg.getChannel();
            FileChannel bimgc = bimg.getChannel();
            ByteBuffer rbuf = ByteBuffer.allocate(pix[r] * rsize);
            ByteBuffer gbuf = ByteBuffer.allocate(pix[g] * gsize);
            ByteBuffer bbuf = ByteBuffer.allocate(pix[b] * bsize);
            try {
                for (int i = 0; i < Scan; ++i) {
                    if ((float)i % scan_inc != 0.0f) continue;
                    if (i < scan[r]) {
                        rimgc.read(rbuf, i * pix[r] * rsize);
                    }
                    if (i < scan[g] && g != r) {
                        gimgc.read(gbuf, i * pix[g] * gsize);
                    }
                    if (i < scan[b] && b != g && b != r) {
                        bimgc.read(bbuf, i * pix[b] * bsize);
                    }
                    for (int j = 0; j < Pix; ++j) {
                        byte v4;
                        byte v3;
                        byte v2;
                        byte v1;
                        if ((float)j % pix_inc != 0.0f) continue;
                        int imgy = (int)((double)(i * Control.refimg.Height) * 1.0 / (double)Scan);
                        int imgx = (int)((double)(j * Control.refimg.Width) * 1.0 / (double)Pix);
                        int rc = 0;
                        int gc = 0;
                        int bc = 0;
                        if (i < scan[r] && j < pix[r]) {
                            if (datatype[r] == 0) {
                                rc = rbuf.get(j) << 24 >>> 24;
                            } else if (datatype[r] == 2) {
                                v1 = rbuf.get(j * 4);
                                v2 = rbuf.get(j * 4 + 1);
                                v3 = rbuf.get(j * 4 + 2);
                                v4 = rbuf.get(j * 4 + 3);
                                rc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                rc = (int)((double)(Float.intBitsToFloat(rc) - (float)minmax[r][0]) * 1.0 / ((double)(minmax[r][1] - minmax[r][0]) * 1.0) * 255.0);
                            }
                            rc = Math.min(255, Math.max(0, rc));
                        }
                        if (g == r) {
                            gc = rc;
                        } else if (i < scan[g] && j < pix[g]) {
                            if (datatype[g] == 0) {
                                gc = gbuf.get(j) << 24 >>> 24;
                            } else if (datatype[g] == 2) {
                                v1 = gbuf.get(j * 4);
                                v2 = gbuf.get(j * 4 + 1);
                                v3 = gbuf.get(j * 4 + 2);
                                v4 = gbuf.get(j * 4 + 3);
                                gc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                gc = (int)((double)(Float.intBitsToFloat(gc) - (float)minmax[g][0]) * 1.0 / ((double)(minmax[g][1] - minmax[g][0]) * 1.0) * 255.0);
                            }
                            gc = Math.min(255, Math.max(0, gc));
                        }
                        if (b == r) {
                            bc = rc;
                        } else if (b == g) {
                            bc = gc;
                        } else if (i < scan[b] && j < pix[b]) {
                            if (datatype[b] == 0) {
                                bc = bbuf.get(j) << 24 >>> 24;
                            } else if (datatype[b] == 2) {
                                v1 = bbuf.get(j * 4);
                                v2 = bbuf.get(j * 4 + 1);
                                v3 = bbuf.get(j * 4 + 2);
                                v4 = bbuf.get(j * 4 + 3);
                                bc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                bc = (int)((double)(Float.intBitsToFloat(bc) - (float)minmax[b][0]) * 1.0 / ((double)(minmax[b][1] - minmax[b][0]) * 1.0) * 255.0);
                            }
                            bc = Math.min(255, Math.max(0, bc));
                        }
                        Color rgb = new Color(rc, gc, bc);
                        Control.refimg.image.setRGB(imgx, imgy, rgb.getRGB());
                    }
                    rbuf.clear();
                    gbuf.clear();
                    bbuf.clear();
                }
                rimgc.close();
                gimg.close();
                bimgc.close();
                rimg.close();
                gimg.close();
                bimg.close();
                Control.refimg.repaint();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading image file.");
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Image file not found.");
        }
    }

    public static void Cfrimage() {
        int Width = Control.frimage.Width;
        int Height = Control.frimage.Height;
        Control.frimage.image = new BufferedImage(Width, Height, 1);
        int r = planeSelect.red;
        int g = planeSelect.green;
        int b = planeSelect.blue;
        int rsize = 0;
        int gsize = 0;
        int bsize = 0;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        w = (int)((double)Width * 1.0 / (2.0 * (double)zlevel));
        h = (int)((double)Height * 1.0 / (2.0 * (double)zlevel));
        x = (int)((double)(Control.refimg.x * Pix) * 1.0 / ((double)Control.refimg.Width * 1.0));
        y = (int)((double)(Control.refimg.y * Scan) * 1.0 / ((double)Control.refimg.Height * 1.0));
        if (datatype[r] == 0 || datatype[r] == 1) {
            rsize = 1;
        } else if (datatype[r] == 2 || datatype[r] == 3) {
            rsize = 4;
        }
        if (datatype[g] == 0 || datatype[g] == 1) {
            gsize = 1;
        } else if (datatype[g] == 2 || datatype[g] == 3) {
            gsize = 4;
        }
        if (datatype[b] == 0 || datatype[b] == 1) {
            bsize = 1;
        } else if (datatype[b] == 2 || datatype[b] == 3) {
            bsize = 4;
        }
        try {
            RandomAccessFile rimg = new RandomAccessFile(file[r], "r");
            RandomAccessFile gimg = new RandomAccessFile(file[g], "r");
            RandomAccessFile bimg = new RandomAccessFile(file[b], "r");
            FileChannel rimgc = rimg.getChannel();
            FileChannel gimgc = gimg.getChannel();
            FileChannel bimgc = bimg.getChannel();
            ByteBuffer rbuf = ByteBuffer.allocate(pix[r] * rsize);
            ByteBuffer gbuf = ByteBuffer.allocate(pix[g] * gsize);
            ByteBuffer bbuf = ByteBuffer.allocate(pix[b] * bsize);
            try {
                for (int imgy = 0; imgy < Width; ++imgy) {
                    int i = (int)((double)(y - h) + (double)imgy * 1.0 / (double)zlevel);
                    if (i < 0) continue;
                    if (i < scan[r]) {
                        rimgc.read(rbuf, i * pix[r] * rsize);
                    }
                    if (i < scan[g] && g != r) {
                        gimgc.read(gbuf, i * pix[g] * gsize);
                    }
                    if (i < scan[b] && b != g && b != r) {
                        bimgc.read(bbuf, i * pix[b] * bsize);
                    }
                    for (int imgx = 0; imgx < Width; ++imgx) {
                        int j = (int)((double)(x - w) + (double)imgx * 1.0 / (double)zlevel);
                        int rc = 0;
                        int gc = 0;
                        int bc = 0;
                        if (j >= 0) {
                            byte v4;
                            byte v3;
                            byte v2;
                            byte v1;
                            if (i < scan[r] && j < pix[r]) {
                                if (datatype[r] == 0) {
                                    rc = rbuf.get(j) << 24 >>> 24;
                                } else if (datatype[r] == 2) {
                                    v1 = rbuf.get(j * 4);
                                    v2 = rbuf.get(j * 4 + 1);
                                    v3 = rbuf.get(j * 4 + 2);
                                    v4 = rbuf.get(j * 4 + 3);
                                    rc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                    rc = (int)((double)(Float.intBitsToFloat(rc) - (float)minmax[r][0]) * 1.0 / ((double)(minmax[r][1] - minmax[r][0]) * 1.0) * 255.0);
                                }
                                rc = Math.min(255, Math.max(0, rc));
                            }
                            if (g == r) {
                                gc = rc;
                            } else if (i < scan[g] && j < pix[g]) {
                                if (datatype[g] == 0) {
                                    gc = gbuf.get(j) << 24 >>> 24;
                                } else if (datatype[g] == 2) {
                                    v1 = gbuf.get(j * 4);
                                    v2 = gbuf.get(j * 4 + 1);
                                    v3 = gbuf.get(j * 4 + 2);
                                    v4 = gbuf.get(j * 4 + 3);
                                    gc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                    gc = (int)((double)(Float.intBitsToFloat(gc) - (float)minmax[g][0]) * 1.0 / ((double)(minmax[g][1] - minmax[g][0]) * 1.0) * 255.0);
                                }
                                gc = Math.min(255, Math.max(0, gc));
                            }
                            if (b == r) {
                                bc = rc;
                            } else if (b == g) {
                                bc = gc;
                            } else if (i < scan[b] && j < pix[b]) {
                                if (datatype[b] == 0) {
                                    bc = bbuf.get(j) << 24 >>> 24;
                                } else if (datatype[b] == 2) {
                                    v1 = bbuf.get(j * 4);
                                    v2 = bbuf.get(j * 4 + 1);
                                    v3 = bbuf.get(j * 4 + 2);
                                    v4 = bbuf.get(j * 4 + 3);
                                    bc = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                                    bc = (int)((double)(Float.intBitsToFloat(bc) - (float)minmax[b][0]) * 1.0 / ((double)(minmax[b][1] - minmax[b][0]) * 1.0) * 255.0);
                                }
                                bc = Math.min(255, Math.max(0, bc));
                            }
                        }
                        Color rgb = new Color(rc, gc, bc);
                        Control.frimage.image.setRGB(imgx, imgy, rgb.getRGB());
                    }
                    rbuf.clear();
                    gbuf.clear();
                    bbuf.clear();
                }
                rimgc.close();
                gimg.close();
                bimgc.close();
                rimg.close();
                gimg.close();
                bimg.close();
                Control.frimage.repaint();
                Control.frimage.scanpix_setvalue();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading image file.");
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Image file not found.");
        }
    }

    static String pixelvalue(int sc, int pi, int p) {
        String str_val = "-";
        if (sc >= 0 && sc < scan[p] && pi >= 0 && pi < pix[p]) {
            int psize = 0;
            if (datatype[p] == 0 || datatype[p] == 1) {
                psize = 1;
            } else if (datatype[p] == 2 || datatype[p] == 3) {
                psize = 4;
            }
            try {
                RandomAccessFile pimg = new RandomAccessFile(file[p], "r");
                FileChannel pimgc = pimg.getChannel();
                ByteBuffer pbuf = ByteBuffer.allocate(pix[p] * psize);
                try {
                    pimgc.read(pbuf, sc * pix[p] * psize);
                    if (datatype[p] == 0) {
                        int c = pbuf.get(pi) << 24 >>> 24;
                        str_val = Integer.toString(c);
                    } else if (datatype[p] == 2) {
                        byte v1 = pbuf.get(pi * 4);
                        byte v2 = pbuf.get(pi * 4 + 1);
                        byte v3 = pbuf.get(pi * 4 + 2);
                        byte v4 = pbuf.get(pi * 4 + 3);
                        int c = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                        str_val = Float.toString(Float.intBitsToFloat(c));
                    }
                    pbuf.clear();
                    pimgc.close();
                    pimg.close();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Error reading image file.");
                }
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "Image file not found.");
            }
        }
        return str_val;
    }

    static void setHistogram(int p) {
        int i;
        for (int j = 0; j < 256; ++j) {
            Control.histogram.histcount[p][j] = 0;
        }
        int psize = 0;
        if (datatype[p] == 0 || datatype[p] == 1) {
            psize = 1;
        } else if (datatype[p] == 2 || datatype[p] == 3) {
            psize = 4;
        }
        try {
            RandomAccessFile pimg = new RandomAccessFile(file[p], "r");
            FileChannel pimgc = pimg.getChannel();
            ByteBuffer pbuf = ByteBuffer.allocate(pix[p] * psize);
            try {
                for (int i2 = 0; i2 < scan[p]; ++i2) {
                    pimgc.read(pbuf, i2 * pix[p] * psize);
                    for (int j = 0; j < pix[p]; ++j) {
                        int c = 0;
                        if (datatype[p] == 0) {
                            c = pbuf.get(j) << 24 >>> 24;
                        } else if (datatype[p] == 2) {
                            byte v1 = pbuf.get(j * 4);
                            byte v2 = pbuf.get(j * 4 + 1);
                            byte v3 = pbuf.get(j * 4 + 2);
                            byte v4 = pbuf.get(j * 4 + 3);
                            c = (v4 << 24) + (v3 << 24 >>> 8) + (v2 << 24 >>> 16) + (v1 << 24 >>> 24);
                            c = (int)((double)(Float.intBitsToFloat(c) - (float)minmax[p][0]) * 1.0 / ((double)(minmax[p][1] - minmax[p][0]) * 1.0) * 255.0);
                        }
                        c = Math.max(0, Math.min(c, 255));
                        int[] nArray = Control.histogram.histcount[p];
                        int n = c;
                        nArray[n] = nArray[n] + 1;
                        pbuf.clear();
                    }
                }
                pimgc.close();
                pimg.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error reading image file.");
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Image file not found.");
        }
        Control.histogram.histmax[p] = 0;
        for (i = 1; i < 255; ++i) {
            if (Control.histogram.histmax[p] >= Control.histogram.histcount[p][i]) continue;
            Control.histogram.histmax[p] = Control.histogram.histcount[p][i];
        }
        if (Control.histogram.histmax[p] == 0) {
            JOptionPane.showMessageDialog(null, "Error creating image histogram.\nPlease report error.");
            Control.histogram.histmax[p] = 1;
        }
        for (i = 1; i < 255; ++i) {
            if (!((double)Control.histogram.histcount[p][i] > 0.001 * (double)Control.histogram.histmax[p])) continue;
            Control.histogram.point[p][1][0] = i;
            Control.histogram.point[p][1][1] = i;
            Control.histogram.point[p][1][2] = i;
            Control.histogram.point[p][1][3] = i;
        }
    }

    static BufferedImage adjustimage(BufferedImage image) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        if (planeSelect.red >= 0 && planeSelect.green >= 0 && planeSelect.blue >= 0) {
            int rp = 0;
            int gp = 0;
            int bp = 0;
            if (planeSelect.mode == 1) {
                rp = 1;
                gp = 2;
                bp = 3;
            }
            int rmin = Control.histogram.point[planeSelect.red][0][rp];
            int rmax = Control.histogram.point[planeSelect.red][1][rp];
            int gmin = Control.histogram.point[planeSelect.green][0][gp];
            int gmax = Control.histogram.point[planeSelect.green][1][gp];
            int bmin = Control.histogram.point[planeSelect.blue][0][bp];
            int bmax = Control.histogram.point[planeSelect.blue][1][bp];
            for (int i = 0; i < image.getHeight(); ++i) {
                for (int j = 0; j < image.getWidth(); ++j) {
                    Color rgb = new Color(image.getRGB(j, i));
                    int r = rgb.getRed();
                    int g = rgb.getGreen();
                    int b = rgb.getBlue();
                    if (r < rmin) {
                        r = rmin;
                    }
                    if (r > rmax) {
                        r = rmax;
                    }
                    r = (r - rmin) * (255 / (rmax - rmin));
                    r = Math.max(Math.min(r, 255), 0);
                    if (g < gmin) {
                        g = gmin;
                    }
                    if (g > gmax) {
                        g = gmax;
                    }
                    g = (g - gmin) * (255 / (gmax - gmin));
                    g = Math.max(Math.min(g, 255), 0);
                    if (b < bmin) {
                        b = bmin;
                    }
                    if (b > bmax) {
                        b = bmax;
                    }
                    b = (b - bmin) * (255 / (bmax - bmin));
                    b = Math.max(Math.min(b, 255), 0);
                    rgb = new Color(r, g, b);
                    img.setRGB(j, i, rgb.getRGB());
                }
            }
        } else {
            img = image;
        }
        return img;
    }
}

